(function() {
    if (typeof mfbLive === 'undefined' || !mfbLive.ajax_url) {
        return;
    }

    function initBracket(wrapper) {
        var bracketId = wrapper.getAttribute('data-bracket-id');
        if (!bracketId) return;

        function refresh() {
            var formData = new FormData();
            formData.append('action', 'mfb_get_bracket_html');
            formData.append('id', bracketId);

            fetch(mfbLive.ajax_url, {
                method: 'POST',
                credentials: 'same-origin',
                body: formData
            })
            .then(function(response) { return response.text(); })
            .then(function(html) {
                if (!html) return;
                var tmp = document.createElement('div');
                tmp.innerHTML = html;
                var newBracket = tmp.querySelector('.mfb-bracket');
                var current = wrapper.querySelector('.mfb-bracket');
                if (newBracket && current) {
                    current.parentNode.replaceChild(newBracket, current);
                }
            })
            .catch(function(e) {
                console.error('MFB live update error', e);
            })
            .finally(function() {
                setTimeout(refresh, mfbLive.refresh_interval || 8000);
            });
        }

        setTimeout(refresh, mfbLive.refresh_interval || 8000);
    }

    document.addEventListener('DOMContentLoaded', function() {
        var wrappers = document.querySelectorAll('.mfb-bracket-wrapper[data-bracket-id]');
        wrappers.forEach(initBracket);
    });
})();